/*----------------------------------------------------------------------------

 Copyright (C) Sartorius Stedim Data Analytics AB 2017 -

 Use, modification and distribution are subject to the Boost Software
 License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
*/

#ifndef UTF8UTIL_H_
#define UTF8UTIL_H_

#define _CRT_SECURE_NO_WARNINGS

#include <wchar.h>
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif 


/* Converts active codepage to a UTF-8 string
@return UTF-8 string to be deallocated with free
*/
char* ActiveCPToUTF8(char* instr);

/* Converts UTF-8 codepage to active code page
@return active codepage string encoded to be deallocated with free
*/
char* UTF8toActiveCP(char* instr);

/* Converts UTF-16 string to an UTF-8 string (in Windows). In Linux
   you always use multibyte strings
*/
char* UTF16toUTF8(wchar_t* instr);

/* Converts UTF-8 string to an UTF-16 string (in Windows). In Linux
you always use multibyte strings
*/
wchar_t* UTF8toUTF16(char* instr);

/* Print UTF-8 string to file */
void PrintUTF8String(FILE* file, char* szString);

#ifdef _WIN32 

/* Printf which assumes UTF8 encoding and converts to system default codepage (or UTF16) */
void UTF8_printf(FILE* file, char *fmt, ...);

#include <tchar.h>

/* Convert TCHAR (Windows specific) to UTF8 string. 
   @return UTF-8 string which must be deallocated with free */
char* TCHARtoUTF8(TCHAR* instr);

/* Convert TCHAR (Windows specific) to UTF8 string
  @return TCHAR string which must be deallocated with free. */
TCHAR* UTF8toTCHAR(char* instr);

#else

/* We assume that unix uses UTF8 encoding so printf can directly be used */
#define UTF8_printf fprintf

#endif

#ifdef __cplusplus
}
#endif /*__cplusplus*/


#endif

